import { View, Text, TouchableOpacity } from 'react-native';
import React from 'react';
import AddressStyle from './AddressStyle';
import dpr from '../../Utilities/CustomStyleAttribute/dpr';
import { useState } from 'react';
import { useDispatch } from 'react-redux';
import { postNewAddress } from '../../../redux/slices/user/address/postNewAddress';
import { getMyAddressWithoutLoading } from '../../../redux/slices/user/address/getMyAddress';
import DefaultAddressIcon from '../../../assets/svgs/address/defaultAddress.svg';
import EditIcon from '../../../assets/svgs/profile/edit profile.svg';
import useAuth from '../../../hooks/useAuth';
import { query } from '../../../redux/slices/util/apiRequest';
import CustomSpinner from '../../Utilities/CustomSpinner/CustomSpinner';
import { BASE_API_URL_STG } from '@env';
import useLangTranslation from '../../../hooks/useLangTranslation';
import gapStyle from '../../Utilities/CommonStyles/gap.style';
import CustomSVG from '../../../src/components/CustomSVG/CustomSVG';

const SingleAddress = ({ item, index, navigation }) => {
    const { trans } = useLangTranslation();
    const {
        first_name,
        last_name,
        phone,
        address_1,
        city,
        country_name,
        is_default,
        zip,
        type_of_place,
    } = item;
    const [showLottieAnimation, setShowLottieAnimation] = useState({
        id: null,
        isLoading: false,
    });
    const dispatch = useDispatch();
    const { access_token } = useAuth();
    const handleMakeDefaultAddress = async (item) => {
        setShowLottieAnimation({
            id: item.id,
            isLoading: true,
        });
        const URLFORPUT = `${BASE_API_URL_STG}/user/address/update`;
        const URL = `${BASE_API_URL_STG}/user/addresses`;
        const address = { ...item, is_default: 1 };
        let newAddress = await dispatch(
            postNewAddress({
                access_token,
                URL: URLFORPUT,
                method: 'POST',
                address,
            })
        );
        if (newAddress.payload.records.length === 0) {
            let data = await query(URL, 'GET', access_token);
            const { status: { code } = {}, records } = data?.response;
            if (code === 200) {
                dispatch(getMyAddressWithoutLoading(records?.data));
            }
        }
        setShowLottieAnimation({
            id: item.id,
            isLoading: false,
        });
    };

    return (
        <>
            <View
                style={[
                    AddressStyle.singleAddressCont,
                    AddressStyle.defaultAddress(is_default)
                ]}
            >
                <View style={AddressStyle.titleCont}>
                    <Text style={AddressStyle.title}>
                        {`${trans("Address")} ${index + 1} (${
                            type_of_place.charAt(0).toUpperCase() +
                            type_of_place.slice(1)
                        })`}
                    </Text>
                    <TouchableOpacity
                        onPress={() =>
                            navigation.navigate('add new address', {
                                isUpdate: true,
                                item,
                                index,
                            })
                        }
                    >
                         <View style={AddressStyle.editIcon}>
                            <CustomSVG svgIcon={EditIcon}
                                width={dpr(15)}
                                height={dpr(17)}
                                />
                        </View>
                    </TouchableOpacity>
                </View>
                <View style={[AddressStyle.titleCont, gapStyle.mt19]}>
                    <Text style={[AddressStyle.name, AddressStyle.name2]}>
                        {`${first_name} ${last_name == null ? '' : last_name}`}
                    </Text>
                    <Text
                        style={[AddressStyle.name,AddressStyle.phone]}
                    >
                        {phone}
                    </Text>
                </View>
                <Text
                    style={AddressStyle.address}
                >{`${address_1}. ${trans("City")}: ${city}. ${
                    zip ? `${trans("Postcode")}: ${zip}.` : ''
                } ${trans("Country")}: ${country_name}`}</Text>
                {is_default ? (
                    <View style={AddressStyle.default}>
                        <CustomSVG svgIcon={DefaultAddressIcon} width={dpr(14)} height={dpr(14)} />
                        <Text style={AddressStyle.defaultText}>
                            {trans('Used as default address')}
                        </Text>
                    </View>
                ) : (
                    <TouchableOpacity
                        onPress={() => handleMakeDefaultAddress(item)}
                        style={AddressStyle.default}
                    >
                        <Text style={AddressStyle.makeDefault}>
                            {trans('Make as default address')}
                        </Text>
                        {showLottieAnimation.id === item.id &&
                            showLottieAnimation.isLoading && (
                                <CustomSpinner
                                    filePath={require('../../../assets/lottie/loader2.json')}
                                    size={{
                                        width: dpr(45),
                                        height: dpr(40),
                                    }}
                                />
                            )}
                    </TouchableOpacity>
                )}
            </View>
        </>
    );
};

export default SingleAddress;
